/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.single;

import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Scheduler;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Single;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.SingleObserver;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.SingleSource;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.DisposableHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.ExceptionHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleTimeout<T>
extends Single<T> {
    final SingleSource<T> source;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final SingleSource<? extends T> other;

    public SingleTimeout(SingleSource<T> source, long timeout, TimeUnit unit, Scheduler scheduler, SingleSource<? extends T> other) {
        this.source = source;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.other = other;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        TimeoutMainObserver<? extends T> parent = new TimeoutMainObserver<T>(observer, this.other, this.timeout, this.unit);
        observer.onSubscribe(parent);
        DisposableHelper.replace(parent.task, this.scheduler.scheduleDirect(parent, this.timeout, this.unit));
        this.source.subscribe(parent);
    }

    static final class TimeoutMainObserver<T>
    extends AtomicReference<Disposable>
    implements SingleObserver<T>,
    Runnable,
    Disposable {
        private static final long serialVersionUID = 37497744973048446L;
        final SingleObserver<? super T> downstream;
        final AtomicReference<Disposable> task;
        final TimeoutFallbackObserver<T> fallback;
        SingleSource<? extends T> other;
        final long timeout;
        final TimeUnit unit;

        TimeoutMainObserver(SingleObserver<? super T> actual, SingleSource<? extends T> other, long timeout, TimeUnit unit) {
            this.downstream = actual;
            this.other = other;
            this.timeout = timeout;
            this.unit = unit;
            this.task = new AtomicReference();
            this.fallback = other != null ? new TimeoutFallbackObserver<T>(actual) : null;
        }

        @Override
        public void run() {
            Disposable d = (Disposable)this.get();
            if (d != DisposableHelper.DISPOSED && this.compareAndSet(d, DisposableHelper.DISPOSED)) {
                SingleSource<T> other;
                if (d != null) {
                    d.dispose();
                }
                if ((other = this.other) == null) {
                    this.downstream.onError(new TimeoutException(ExceptionHelper.timeoutMessage(this.timeout, this.unit)));
                } else {
                    this.other = null;
                    other.subscribe(this.fallback);
                }
            }
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this, d);
        }

        @Override
        public void onSuccess(T t) {
            Disposable d = (Disposable)this.get();
            if (d != DisposableHelper.DISPOSED && this.compareAndSet(d, DisposableHelper.DISPOSED)) {
                DisposableHelper.dispose(this.task);
                this.downstream.onSuccess(t);
            }
        }

        @Override
        public void onError(Throwable e) {
            Disposable d = (Disposable)this.get();
            if (d != DisposableHelper.DISPOSED && this.compareAndSet(d, DisposableHelper.DISPOSED)) {
                DisposableHelper.dispose(this.task);
                this.downstream.onError(e);
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
            DisposableHelper.dispose(this.task);
            if (this.fallback != null) {
                DisposableHelper.dispose(this.fallback);
            }
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        static final class TimeoutFallbackObserver<T>
        extends AtomicReference<Disposable>
        implements SingleObserver<T> {
            private static final long serialVersionUID = 2071387740092105509L;
            final SingleObserver<? super T> downstream;

            TimeoutFallbackObserver(SingleObserver<? super T> downstream) {
                this.downstream = downstream;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onSuccess(T t) {
                this.downstream.onSuccess(t);
            }

            @Override
            public void onError(Throwable e) {
                this.downstream.onError(e);
            }
        }
    }
}

